# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 6
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR6_strategy.txt
# LLM Suggested Fallback: C

def radiant_phoenix(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Phase: Cooperate for first 3 rounds
    if current_round <= 3:
        return "C"
    
    # Middle Phase: Analyze opponent's code and behavior
    always_c = "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code
    always_d = "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code
    
    if always_c or always_d:
        return "D"
    
    if current_round <= 7:
        if len(opp_history) > 0:
            return opp_history[-1]
        else:
            return "C"
    
    # Late Phase: Test opponent's reaction
    if current_round == 8:
        return "D"
    else:
        if len(opp_history) > 0:
            if opp_history[-1] == "D":
                return "D"
            else:
                return "D" if current_round > 8 else "C"
        else:
            return "C"